/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class ChildLinkInserter {
    private static final String UTF_8 = "UTF-8";
    private HttpServletRequest req;
    private OutputStream out;
    private static final String NO_CHILDREN = "no_child_topics";
    private static final String HAS_CHILDREN = "has_child_topics";
    private AbstractHelpScope scope;

    public ChildLinkInserter(HttpServletRequest req, OutputStream out) {
        this.req = req;
        this.out = out;
        this.scope = RequestScope.getScope(req, null, false);
    }

    public void addContents(String encoding) throws IOException {
        ITopic[] subtopics = this.getSubtopics();
        if (subtopics.length == 0) {
            return;
        }
        StringBuffer links = new StringBuffer("\n<ul class=\"childlinks\">\n");
        int i = 0;
        while (i < subtopics.length) {
            if (ScopeUtils.showInTree((ITopic)subtopics[i], (AbstractHelpScope)this.scope)) {
                links.append("\n<li><a href=\"");
                String href = subtopics[i].getHref();
                href = href == null ? "nav.html" : XMLGenerator.xmlEscape(href);
                links.append(this.getBackpath(this.req.getPathInfo()));
                links.append(href);
                links.append("\">" + subtopics[i].getLabel() + "</a></li>\n");
            }
            ++i;
        }
        links.append("\n</ul>\n");
        String linkString = links.toString();
        try {
            if (encoding != null) {
                this.out.write(linkString.getBytes(encoding));
            } else {
                this.out.write(linkString.getBytes("UTF8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.out.write(linkString.getBytes());
        }
    }

    private ITopic[] getSubtopics() {
        String locale = UrlUtil.getLocale(this.req, null);
        String pathInfo = this.req.getPathInfo();
        String servletPath = this.req.getServletPath();
        if ("/nav".equals(servletPath)) {
            return new ITopic[0];
        }
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            if (pathInfo.equals(tocs[i].getTopic())) {
                return tocs[i].getTopics();
            }
            ITopic topic = tocs[i].getTopic(pathInfo);
            if (topic != null) {
                return topic.getSubtopics();
            }
            ++i;
        }
        return new ITopic[0];
    }

    private String getBackpath(String path) {
        int num = new Path(path).segmentCount() - 1;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < num) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append("..");
            ++i;
        }
        return buf.toString();
    }

    public void addStyle() throws UnsupportedEncodingException, IOException {
        ITopic[] subtopics = this.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            if (ScopeUtils.showInTree((ITopic)subtopics[i], (AbstractHelpScope)this.scope)) {
                this.out.write(HAS_CHILDREN.getBytes(UTF_8));
                return;
            }
            ++i;
        }
        this.out.write(NO_CHILDREN.getBytes(UTF_8));
    }
}

