/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.dynamic.ProcessorHandler;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XHTMLCharsetHandler
extends ProcessorHandler {
    private static final String ELEMENT_META = "meta";
    private static final String ATTRIBUTE_CONTENT = "content";
    private static final String PREFIX_CHARSET = "text/html; charset=";
    private static final String ENCODING_UTF8 = "UTF-8";

    public short handle(UAElement element, String id) {
        Element domElement;
        String content;
        if (ELEMENT_META.equals(element.getElementName()) && (content = element.getAttribute(ATTRIBUTE_CONTENT)) != null && content.startsWith(PREFIX_CHARSET)) {
            element.setAttribute(ATTRIBUTE_CONTENT, "text/html; charset=UTF-8");
            return 1;
        }
        if (this.endTagRequired(element) && (domElement = element.getElement()).getFirstChild() == null) {
            Document document = domElement.getOwnerDocument();
            Comment child = document.createComment(" ");
            domElement.appendChild(child);
        }
        return 0;
    }

    private boolean endTagRequired(UAElement element) {
        String elementName = element.getElementName();
        if ("a".equalsIgnoreCase(elementName)) {
            return true;
        }
        if ("p".equalsIgnoreCase(elementName)) {
            return true;
        }
        if ("div".equalsIgnoreCase(elementName)) {
            return true;
        }
        if ("script".equalsIgnoreCase(elementName)) {
            return true;
        }
        return "textarea".equalsIgnoreCase(elementName);
    }
}

