/*
 * Decompiled with CFR 0.152.
 */
package com.routlets.usage;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epp.usagedata.internal.gathering.monitors.UsageMonitor;
import org.eclipse.epp.usagedata.internal.gathering.services.UsageDataService;

public class LogMonitor
implements UsageMonitor,
ILogListener {
    private static final String WHAT_ERROR = "error";
    private static final String KIND_DETAIL = "log_detail";
    private static final String KIND_STACK = "log_stack";
    private UsageDataService usageDataService;

    public void startMonitoring(UsageDataService usageDataService) {
        this.usageDataService = usageDataService;
        Platform.addLogListener((ILogListener)this);
    }

    public void stopMonitoring() {
        Platform.removeLogListener((ILogListener)this);
    }

    public void logging(IStatus iStatus, String string) {
        if (iStatus.getSeverity() != 4) {
            return;
        }
        Throwable throwable = iStatus.getException();
        if (throwable == null) {
            return;
        }
        while (throwable.getCause() != null && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof RuntimeException) {
            StackTraceElement[] stackTraceElementArray;
            String string2 = throwable.toString();
            if (iStatus.getMessage() == null || !iStatus.getMessage().contains(string2)) {
                this.usageDataService.recordEvent(WHAT_ERROR, KIND_DETAIL, string2, null);
            }
            if ((stackTraceElementArray = throwable.getStackTrace()).length > 0) {
                this.usageDataService.recordEvent(WHAT_ERROR, KIND_STACK, stackTraceElementArray[0].toString(), null);
            }
        }
    }
}

