/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search.federated;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.search.SearchResults;
import org.eclipse.help.internal.search.federated.LocalHelpScope;
import org.eclipse.help.internal.workingset.WorkingSet;
import org.eclipse.help.search.AbstractSearchProcessor;
import org.eclipse.help.search.ISearchEngine2;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchResult;
import org.eclipse.help.search.ISearchScope;
import org.eclipse.help.search.SearchParticipant;
import org.eclipse.help.search.SearchProcessorInfo;

public class LocalHelp
implements ISearchEngine2 {
    private static final int MAX_HITS = 500;
    private List altList;

    public void run(String query, ISearchScope scope, ISearchEngineResultCollector collector, IProgressMonitor monitor) throws CoreException {
        AbstractSearchProcessor[] processors = SearchManager.getSearchProcessors();
        this.altList = new ArrayList();
        int p = 0;
        while (p < processors.length) {
            SearchProcessorInfo result = processors[p].preSearch(query);
            if (result != null) {
                String modQuery;
                String[] alternates = result.getAlternateTerms();
                if (alternates != null) {
                    int a = 0;
                    while (a < alternates.length) {
                        if (!this.altList.contains(alternates[a])) {
                            this.altList.add(alternates[a]);
                        }
                        ++a;
                    }
                }
                if ((modQuery = result.getQuery()) != null) {
                    query = modQuery;
                }
            }
            ++p;
        }
        Collections.sort(this.altList);
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.setSearchWord(query);
        WorkingSet[] workingSets = null;
        LocalHelpScope localScope = (LocalHelpScope)scope;
        if (localScope.getWorkingSet() != null) {
            workingSets = new WorkingSet[]{localScope.getWorkingSet()};
        }
        SearchResults localResults = new SearchResults(workingSets, 500, Platform.getNL());
        try {
            Job.getJobManager().join((Object)"org.eclipse.help.base.indexer", monitor);
        }
        catch (InterruptedException interruptedException) {}
        BaseHelpSystem.getSearchManager().search(searchQuery, localResults, monitor);
        ISearchResult[] results = SearchManager.convertHitsToResults(localResults.getSearchHits());
        boolean reset = false;
        int p2 = 0;
        while (p2 < processors.length) {
            ISearchResult[] tmp = processors[p2].postSearch(query, results);
            if (tmp != null) {
                reset = true;
                results = tmp;
            }
            ++p2;
        }
        if (reset) {
            SearchHit[] hits = SearchManager.convertResultsToHits(results);
            localResults.setHits(hits);
        }
        this.postResults(localResults, collector, localScope.getCapabilityFiltered());
    }

    private void postResults(SearchResults results, ISearchEngineResultCollector collector, boolean activityFiltering) {
        if (results.getException() != null) {
            collector.error((IStatus)new Status(4, "org.eclipse.help.base", HelpBaseResources.HelpSearch_QueryTooComplex, (Throwable)results.getException()));
        }
        ISearchEngineResult[] searchHits = results.getSearchHits();
        if (HelpPlugin.DEBUG_SEARCH) {
            int i = 0;
            while (i < 10 && i < searchHits.length) {
                System.out.println("Score " + ((SearchHit)searchHits[i]).getScore() + ": " + ((SearchHit)searchHits[i]).getLabel());
                ++i;
            }
        }
        if (!activityFiltering) {
            collector.accept(searchHits);
            return;
        }
        ArrayList<ISearchEngineResult> enabledHits = new ArrayList<ISearchEngineResult>();
        int i = 0;
        while (i < searchHits.length) {
            ISearchEngineResult hit = searchHits[i];
            if (((SearchHit)hit).getParticipantId() != null) {
                if (HelpBasePlugin.getActivitySupport().isEnabled(((SearchHit)hit).getHref())) {
                    enabledHits.add(hit);
                }
            } else if (HelpBasePlugin.getActivitySupport().isEnabledTopic(((SearchHit)hit).getHref(), Platform.getNL())) {
                enabledHits.add(hit);
            }
            ++i;
        }
        collector.accept(enabledHits.toArray(new SearchHit[enabledHits.size()]));
    }

    public String toAbsoluteHref(String href, boolean frames) {
        return null;
    }

    public List getAlternates() {
        return this.altList;
    }

    public boolean open(String id) {
        int sep = id.indexOf(47);
        if (sep == -1) {
            return false;
        }
        String participantId = id.substring(0, sep);
        id = id.substring(sep + 1);
        SearchParticipant participant = BaseHelpSystem.getLocalSearchManager().getGlobalParticipant(participantId);
        if (participant == null) {
            return false;
        }
        try {
            return participant.open(id);
        }
        catch (Throwable t) {
            HelpBasePlugin.logError("Error occured in search participant trying to open document with id: " + id + ", participant: " + participant.getClass().getName(), t);
            return false;
        }
    }
}

