/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.gathering.monitors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public class ExtensionIdToBundleMapper {
    private Map<String, String> map;
    private final String extensionPointId;
    private IRegistryChangeListener listener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            if (this.extensionsAdded(event)) {
                ExtensionIdToBundleMapper.this.clearCache();
            }
        }

        private boolean extensionsAdded(IRegistryChangeEvent event) {
            IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas();
            int n = iExtensionDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                if (delta.getExtensionPoint().getUniqueIdentifier().equals(ExtensionIdToBundleMapper.this.extensionPointId)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    };

    public ExtensionIdToBundleMapper(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.hookListeners();
    }

    void hookListeners() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this.listener);
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.listener);
        this.clearCache();
    }

    protected synchronized String getBundleId(String extensionId) {
        this.updateCommandToBundleMappings();
        return this.map.get(extensionId);
    }

    private synchronized void clearCache() {
        this.map = null;
    }

    private synchronized void updateCommandToBundleMappings() {
        IConfigurationElement[] elements;
        if (this.map != null) {
            return;
        }
        this.map = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointId);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.map.put(element.getAttribute("id"), element.getContributor().getName());
            ++n2;
        }
    }
}

