/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEvent;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEventListener;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecorderUtils;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecordingActivator;
import org.eclipse.epp.usagedata.internal.recording.settings.UsageDataRecordingSettings;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadManager;

public class UsageDataRecorder
implements UsageDataEventListener {
    private static final int EVENT_COUNT_THRESHOLD = 25;
    private static final int EXCEPTION_THRESHOLD = 5;
    private static final long FILE_SIZE_THRESHOLD = 25000L;
    private List<UsageDataEvent> events;
    private boolean running = false;
    private int exceptionCount = 0;

    public void start() {
        if (this.running) {
            return;
        }
        this.events = new ArrayList<UsageDataEvent>(25);
        this.running = true;
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.dumpEvents();
        this.events = null;
    }

    public synchronized void accept(UsageDataEvent event) {
        if (event == null) {
            return;
        }
        if (!this.canAcceptEvents()) {
            return;
        }
        if (!this.running) {
            return;
        }
        this.events.add(event);
        if (this.events.size() >= 25) {
            this.dumpEvents();
        }
        this.uploadDataIfNecessary();
    }

    protected void uploadDataIfNecessary() {
        if (this.getSettings() == null) {
            return;
        }
        if (!this.getSettings().isTimeToUpload()) {
            return;
        }
        UploadManager manager = this.getUploadManager();
        if (manager == null) {
            return;
        }
        manager.startUpload();
    }

    protected UsageDataRecordingSettings getSettings() {
        if (UsageDataRecordingActivator.getDefault() == null) {
            return null;
        }
        return UsageDataRecordingActivator.getDefault().getSettings();
    }

    private synchronized void prepareForUpload() {
        if (this.getSettings() == null) {
            return;
        }
        File file = this.getSettings().getEventFile();
        if (!file.exists()) {
            return;
        }
        if (file.length() < 25000L) {
            return;
        }
        File destination = this.getSettings().computeDestinationFile();
        file.renameTo(destination);
    }

    private UploadManager getUploadManager() {
        if (UsageDataRecordingActivator.getDefault() == null) {
            return null;
        }
        return UsageDataRecordingActivator.getDefault().getUploadManager();
    }

    private boolean canAcceptEvents() {
        return this.events != null;
    }

    protected synchronized void dumpEvents() {
        this.prepareForUpload();
        Writer writer = null;
        try {
            writer = this.getWriter();
            if (writer == null) {
                return;
            }
            try {
                for (UsageDataEvent event : this.events) {
                    UsageDataRecorderUtils.writeEvent(writer, event);
                }
                this.events.clear();
            }
            catch (IOException e) {
                this.handleException(e, "Error writing events to file.");
            }
        }
        finally {
            this.close(writer);
        }
    }

    private void handleException(IOException e, String message) {
        if (this.exceptionCount++ > 5) {
            UsageDataRecordingActivator.getDefault().log(1, e, "The UsageDataRecorder has been stopped because it has caused too many exceptions");
            this.stop();
        }
        UsageDataRecordingActivator.getDefault().log(4, e, message);
    }

    private Writer getWriter() throws IOException {
        if (this.getSettings() == null) {
            return null;
        }
        return this.createEventWriter(this.getSettings().getEventFile());
    }

    private Writer createEventWriter(File file) throws IOException {
        if (file.exists()) {
            return new FileWriter(file, true);
        }
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        UsageDataRecorderUtils.writeHeader(writer);
        return writer;
    }

    private void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {}
    }
}

