/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitCollectorWrapper;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

final class BooleanScorer
extends Scorer {
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable();
    private int maxCoord = 1;
    private final float[] coordFactors;
    private int requiredMask = 0;
    private int prohibitedMask = 0;
    private int nextMask = 1;
    private final int minNrShouldMatch;
    private int end;
    private Bucket current;
    private int doc = -1;

    BooleanScorer(Similarity similarity, int minNrShouldMatch, List optionalScorers, List prohibitedScorers) throws IOException {
        super(similarity);
        Scorer scorer;
        Iterator si;
        this.minNrShouldMatch = minNrShouldMatch;
        if (optionalScorers != null && optionalScorers.size() > 0) {
            si = optionalScorers.iterator();
            while (si.hasNext()) {
                scorer = (Scorer)si.next();
                ++this.maxCoord;
                if (scorer.nextDoc() == Integer.MAX_VALUE) continue;
                this.scorers = new SubScorer(scorer, false, false, this.bucketTable.newCollector(0), this.scorers);
            }
        }
        if (prohibitedScorers != null && prohibitedScorers.size() > 0) {
            si = prohibitedScorers.iterator();
            while (si.hasNext()) {
                scorer = (Scorer)si.next();
                int mask = this.nextMask;
                this.nextMask <<= 1;
                this.prohibitedMask |= mask;
                if (scorer.nextDoc() == Integer.MAX_VALUE) continue;
                this.scorers = new SubScorer(scorer, false, true, this.bucketTable.newCollector(mask), this.scorers);
            }
        }
        this.coordFactors = new float[this.maxCoord];
        Similarity sim = this.getSimilarity();
        for (int i = 0; i < this.maxCoord; ++i) {
            this.coordFactors[i] = sim.coord(i, this.maxCoord - 1);
        }
    }

    protected boolean score(Collector collector, int max, int firstDocID) throws IOException {
        boolean more;
        BucketScorer bs = new BucketScorer();
        collector.setScorer(bs);
        do {
            this.bucketTable.first = null;
            while (this.current != null) {
                if ((this.current.bits & this.prohibitedMask) == 0 && (this.current.bits & this.requiredMask) == this.requiredMask) {
                    if (this.current.doc >= max) {
                        Bucket tmp = this.current;
                        this.current = this.current.next;
                        tmp.next = this.bucketTable.first;
                        this.bucketTable.first = tmp;
                        continue;
                    }
                    if (this.current.coord >= this.minNrShouldMatch) {
                        bs.score = this.current.score * this.coordFactors[this.current.coord];
                        bs.doc = this.current.doc;
                        collector.collect(this.current.doc);
                    }
                }
                this.current = this.current.next;
            }
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                return true;
            }
            more = false;
            this.end += 2048;
            SubScorer sub = this.scorers;
            while (sub != null) {
                int subScorerDocID = sub.scorer.docID();
                if (subScorerDocID != Integer.MAX_VALUE) {
                    more |= sub.scorer.score(sub.collector, this.end, subScorerDocID);
                }
                sub = sub.next;
            }
            this.current = this.bucketTable.first;
        } while (this.current != null || more);
        return false;
    }

    protected boolean score(HitCollector hc, int max) throws IOException {
        return this.score(new HitCollectorWrapper(hc), max, this.docID());
    }

    public int advance(int target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int doc() {
        return this.current.doc;
    }

    public int docID() {
        return this.doc;
    }

    public Explanation explain(int doc) {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    public int nextDoc() throws IOException {
        while (true) {
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                if ((this.current.bits & this.prohibitedMask) != 0 || (this.current.bits & this.requiredMask) != this.requiredMask || this.current.coord < this.minNrShouldMatch) continue;
                this.doc = this.current.doc;
                return this.doc;
            }
            boolean more = false;
            this.end += 2048;
            SubScorer sub = this.scorers;
            while (sub != null) {
                Scorer scorer = sub.scorer;
                sub.collector.setScorer(scorer);
                int doc = scorer.docID();
                while (doc < this.end) {
                    sub.collector.collect(doc);
                    doc = scorer.nextDoc();
                }
                more |= doc != Integer.MAX_VALUE;
                sub = sub.next;
            }
            if (this.bucketTable.first == null && !more) break;
        }
        this.doc = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }

    public float score() {
        return this.current.score * this.coordFactors[this.current.coord];
    }

    public void score(Collector collector) throws IOException {
        this.score(collector, Integer.MAX_VALUE, this.nextDoc());
    }

    public void score(HitCollector hc) throws IOException {
        this.score(new HitCollectorWrapper(hc));
    }

    public boolean skipTo(int target) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("boolean(");
        SubScorer sub = this.scorers;
        while (sub != null) {
            buffer.append(sub.scorer.toString());
            buffer.append(" ");
            sub = sub.next;
        }
        buffer.append(")");
        return buffer.toString();
    }

    private static final class BooleanScorerCollector
    extends Collector {
        private BucketTable bucketTable;
        private int mask;
        private Scorer scorer;

        public BooleanScorerCollector(int mask, BucketTable bucketTable) {
            this.mask = mask;
            this.bucketTable = bucketTable;
        }

        public final void collect(int doc) throws IOException {
            BucketTable table = this.bucketTable;
            int i = doc & 0x7FF;
            Bucket bucket = table.buckets[i];
            if (bucket == null) {
                table.buckets[i] = bucket = new Bucket();
            }
            if (bucket.doc != doc) {
                bucket.doc = doc;
                bucket.score = this.scorer.score();
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = table.first;
                table.first = bucket;
            } else {
                bucket.score += this.scorer.score();
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }

        public void setNextReader(IndexReader reader, int docBase) {
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    static final class Bucket {
        int doc = -1;
        float score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    private static final class BucketScorer
    extends Scorer {
        float score;
        int doc = Integer.MAX_VALUE;

        public BucketScorer() {
            super(null);
        }

        public int advance(int target) throws IOException {
            return Integer.MAX_VALUE;
        }

        public int doc() {
            return this.doc;
        }

        public int docID() {
            return this.doc;
        }

        public Explanation explain(int doc) throws IOException {
            return null;
        }

        public boolean next() throws IOException {
            return false;
        }

        public int nextDoc() throws IOException {
            return Integer.MAX_VALUE;
        }

        public float score() throws IOException {
            return this.score;
        }

        public boolean skipTo(int target) throws IOException {
            return false;
        }
    }

    static final class BucketTable {
        public static final int SIZE = 2048;
        public static final int MASK = 2047;
        final Bucket[] buckets = new Bucket[2048];
        Bucket first = null;

        public Collector newCollector(int mask) {
            return new BooleanScorerCollector(mask, this);
        }

        public final int size() {
            return 2048;
        }
    }

    static final class SubScorer {
        public Scorer scorer;
        public boolean required = false;
        public boolean prohibited = false;
        public Collector collector;
        public SubScorer next;

        public SubScorer(Scorer scorer, boolean required, boolean prohibited, Collector collector, SubScorer next) throws IOException {
            this.scorer = scorer;
            this.required = required;
            this.prohibited = prohibited;
            this.collector = collector;
            this.next = next;
        }
    }
}

