/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerSupportView;

public abstract class MarkerViewHandler
extends AbstractHandler {
    private static final IMarker[] EMPTY_MARKER_ARRAY = new IMarker[0];

    public MarkerSupportView getView(ExecutionEvent event) {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof MarkerSupportView)) {
            return null;
        }
        return (MarkerSupportView)part;
    }

    public void execute(IUndoableOperation operation, String title, IProgressMonitor monitor, IAdaptable uiInfo) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(operation, monitor, uiInfo);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, title, e.getCause()), 2);
            }
            StatusManager.getManager().handle(StatusUtil.newStatus(4, title, (Throwable)e));
        }
    }

    public IMarker[] getSelectedMarkers(ExecutionEvent event) {
        final MarkerSupportView view = this.getView(event);
        if (view == null) {
            return EMPTY_MARKER_ARRAY;
        }
        final IMarker[][] result = new IMarker[1][];
        view.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = view.getSelectedMarkers();
            }
        });
        return result[0];
    }
}

