/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.core.history.LocalFileHistory;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.actions.CompareRevisionAction;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.LocalHistoryPage;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IWorkbenchPage;

public class EditionHistoryPage
extends LocalHistoryPage {
    private final IFile file;
    private final Object element;
    private final LocalResourceTypedElement localFileElement;
    private IStructureCreator structureCreator;
    private Map editions = new HashMap();
    private ITypedElement localEdition;
    private String name;
    static /* synthetic */ Class class$0;

    public static ITypedElement getPreviousState(IFile file, Object element) throws TeamException {
        LocalResourceTypedElement localFileElement = new LocalResourceTypedElement((IResource)file);
        IStructureCreator structureCreator = CompareUI.createStructureCreator((ITypedElement)localFileElement);
        if (structureCreator == null) {
            return null;
        }
        LocalFileHistory history = new LocalFileHistory(file, false);
        history.refresh((IProgressMonitor)new NullProgressMonitor());
        IFileRevision[] revisions = history.getFileRevisions();
        if (revisions.length == 0) {
            return null;
        }
        EditionHistoryPage.sortDescending(revisions);
        ITypedElement localEdition = null;
        try {
            localEdition = EditionHistoryPage.createLocalEdition(structureCreator, (ITypedElement)localFileElement, element);
            int i = 0;
            while (i < revisions.length) {
                IFileRevision revision = revisions[i];
                ITypedElement edition = EditionHistoryPage.createEdition(structureCreator, element, new FileRevisionTypedElement(revision));
                if (edition != null && !EditionHistoryPage.contentsEqual(structureCreator, localEdition, edition)) {
                    ITypedElement iTypedElement = edition;
                    return iTypedElement;
                }
                ++i;
            }
        }
        finally {
            if (localEdition != null) {
                EditionHistoryPage.destroyLocalEdition(structureCreator, localFileElement, localEdition);
            }
        }
        return null;
    }

    public EditionHistoryPage(IFile file, Object element) {
        super(5);
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)element);
        this.file = file;
        this.element = element;
        this.localFileElement = new LocalResourceTypedElement((IResource)this.getFile());
        this.structureCreator = CompareUI.createStructureCreator((ITypedElement)this.localFileElement);
    }

    public void setSite(IHistoryPageSite site) {
        super.setSite(site);
        if (site.isModal()) {
            this.localEdition = EditionHistoryPage.createLocalEdition(this.structureCreator, (ITypedElement)this.localFileElement, this.element);
        }
    }

    protected IFile getFile() {
        return this.file;
    }

    protected void update(IFileRevision[] revisions, IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        ITypedElement te = null;
        try {
            te = this.localEdition == null ? EditionHistoryPage.createLocalEdition(this.structureCreator, (ITypedElement)this.localFileElement, this.element) : this.localEdition;
            if (te != null) {
                String oldValue = this.getName();
                String oldDesc = this.getDescription();
                this.name = te.getName();
                IFileRevision[] filtered = this.filterRevisions(te, revisions, Policy.subMonitorFor(monitor, 75));
                super.update(filtered, Policy.subMonitorFor(monitor, 25));
                this.firePropertyChange(this, "org.eclipse.team.ui.name", oldValue, this.getName());
                this.firePropertyChange(this, "org.eclipse.team.ui.description", oldDesc, this.getDescription());
            }
        }
        finally {
            if (this.localEdition == null && te != null) {
                EditionHistoryPage.internalDestroy(this.structureCreator, te);
            }
            monitor.done();
        }
    }

    private IFileRevision[] filterRevisions(ITypedElement localEdition, IFileRevision[] revisions, IProgressMonitor monitor) {
        ITypedElement previousEdition = localEdition;
        ArrayList<IFileRevision> result = new ArrayList<IFileRevision>();
        EditionHistoryPage.sortDescending(revisions);
        this.editions.clear();
        int i = 0;
        while (i < revisions.length) {
            IFileRevision revision = revisions[i];
            ITypedElement edition = this.createEdition(new FileRevisionTypedElement(revision));
            if (edition != null && !EditionHistoryPage.contentsEqual(this.structureCreator, previousEdition, edition)) {
                this.editions.put(revision, edition);
                previousEdition = edition;
                result.add(revision);
            }
            ++i;
        }
        return result.toArray(new IFileRevision[result.size()]);
    }

    private static void sortDescending(IFileRevision[] revisions) {
        Arrays.sort(revisions, new Comparator(){

            public int compare(Object o1, Object o2) {
                IFileRevision d1 = (IFileRevision)o1;
                IFileRevision d2 = (IFileRevision)o2;
                long d = d2.getTimestamp() - d1.getTimestamp();
                if (d < 0L) {
                    return -1;
                }
                if (d > 0L) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private static boolean contentsEqual(IStructureCreator creator, ITypedElement previousEdition, ITypedElement edition) {
        if (previousEdition == null || creator == null || edition == null) {
            return false;
        }
        String contents1 = creator.getContents((Object)previousEdition, false);
        String contents2 = creator.getContents((Object)edition, false);
        return contents1 != null && contents2 != null && contents1.equals(contents2);
    }

    public ICompareInput getCompareInput(Object object) {
        ITypedElement edition = this.getEditionFor(object);
        if (edition != null && this.localEdition != null) {
            return new DiffNode(this.localEdition, edition);
        }
        return null;
    }

    public ITypedElement getEditionFor(Object object) {
        return (ITypedElement)this.editions.get(object);
    }

    private static ITypedElement createLocalEdition(IStructureCreator creator, ITypedElement input, Object element) {
        if (creator == null) {
            return null;
        }
        ITypedElement result = null;
        if (creator instanceof IStructureCreator2) {
            IStructureCreator2 sc2 = (IStructureCreator2)creator;
            try {
                result = sc2.createElement(element, (Object)input, null);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        if (result == null) {
            result = EditionHistoryPage.createEdition(creator, element, input);
        }
        return result;
    }

    private ITypedElement createEdition(ITypedElement input) {
        return EditionHistoryPage.createEdition(this.structureCreator, this.element, input);
    }

    private static ITypedElement createEdition(IStructureCreator creator, Object element, ITypedElement input) {
        if (creator == null) {
            return null;
        }
        IStructureComparator edition = creator.locate(element, (Object)input);
        if (edition instanceof ITypedElement) {
            return (ITypedElement)edition;
        }
        return null;
    }

    public boolean isValidInput(Object object) {
        return object.equals(this.element);
    }

    public void dispose() {
        try {
            this.disconnect();
        }
        finally {
            super.dispose();
        }
    }

    private void disconnect() {
        if (this.localFileElement != null) {
            this.localFileElement.discardBuffer();
        }
        EditionHistoryPage.internalDestroy(this.structureCreator, this.localEdition);
        this.localEdition = null;
        this.structureCreator = null;
    }

    private static void internalDestroy(IStructureCreator creator, ITypedElement te) {
        if (te != null && creator instanceof IStructureCreator2) {
            IStructureCreator2 sc2 = (IStructureCreator2)creator;
            sc2.destroy((Object)te);
        }
    }

    private static void destroyLocalEdition(IStructureCreator structureCreator, LocalResourceTypedElement localFileElement, ITypedElement localEdition) {
        if (localFileElement != null) {
            localFileElement.discardBuffer();
        }
        if (localEdition != null && structureCreator instanceof IStructureCreator2) {
            IStructureCreator2 sc2 = (IStructureCreator2)structureCreator;
            sc2.destroy((Object)localEdition);
        }
    }

    protected String getNoChangesMessage() {
        if (this.name != null) {
            return NLS.bind((String)TeamUIMessages.EditionHistoryPage_0, (Object)this.name);
        }
        return TeamUIMessages.EditionHistoryPage_1;
    }

    protected Image getImage(Object object) {
        if (object == this.localEdition) {
            return this.localEdition.getImage();
        }
        Object revision = this.getRevisionFor(object);
        if (revision != null) {
            return super.getImage(revision);
        }
        return super.getImage(object);
    }

    protected String getLabel(Object object) {
        Object revision = this.getRevisionFor(object);
        if (revision != null) {
            return super.getLabel(revision);
        }
        return super.getLabel(object);
    }

    private Object getRevisionFor(Object object) {
        if (object == this.localEdition) {
            return this.localFileElement;
        }
        Iterator iterator = this.editions.keySet().iterator();
        while (iterator.hasNext()) {
            IFileRevision revision = (IFileRevision)iterator.next();
            if (this.editions.get(revision) != object) continue;
            return revision;
        }
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    public String getDescription() {
        if (this.name != null) {
            return NLS.bind((String)TeamUIMessages.EditionHistoryPage_2, (Object)this.name);
        }
        return super.getDescription();
    }

    protected CompareRevisionAction createCompareAction() {
        return new CompareEditionAction((HistoryPage)this);
    }

    class CompareEditionAction
    extends CompareRevisionAction {
        public CompareEditionAction(HistoryPage page) {
            super(page);
        }

        protected ITypedElement getElementFor(IResource resource) {
            if (resource.equals((Object)EditionHistoryPage.this.file)) {
                return EditionHistoryPage.this.localFileElement;
            }
            return super.getElementFor(resource);
        }

        protected CompareFileRevisionEditorInput createCompareEditorInput(ITypedElement left, ITypedElement right, IWorkbenchPage page) {
            ITypedElement leftEdition = this.getEdition(left);
            boolean leftIsLocal = false;
            if (leftEdition == null && left instanceof LocalResourceTypedElement) {
                leftEdition = EditionHistoryPage.createLocalEdition(EditionHistoryPage.this.structureCreator, (ITypedElement)EditionHistoryPage.this.localFileElement, EditionHistoryPage.this.element);
                leftIsLocal = true;
            }
            ITypedElement rightEdition = this.getEdition(right);
            return new CompareEditionsEditorInput(EditionHistoryPage.this.structureCreator, left, right, leftEdition, rightEdition, leftIsLocal, page);
        }

        private ITypedElement getEdition(ITypedElement input) {
            if (input instanceof FileRevisionTypedElement) {
                FileRevisionTypedElement te = (FileRevisionTypedElement)input;
                return EditionHistoryPage.this.getEditionFor(te.getRevision());
            }
            return null;
        }
    }

    static class CompareEditionsEditorInput
    extends CompareFileRevisionEditorInput {
        private final ITypedElement leftRevision;
        private final ITypedElement rightRevision;
        private final boolean leftIsLocal;
        private IStructureCreator structureCreator;

        public CompareEditionsEditorInput(IStructureCreator structureCreator, ITypedElement left, ITypedElement right, ITypedElement leftEdition, ITypedElement rightEdition, boolean leftIsLocal, IWorkbenchPage page) {
            super(leftEdition, rightEdition, page);
            this.structureCreator = structureCreator;
            this.leftRevision = left;
            this.rightRevision = right;
            this.leftIsLocal = leftIsLocal;
        }

        public LocalResourceTypedElement getLocalElement() {
            if (this.leftRevision instanceof LocalResourceTypedElement) {
                return (LocalResourceTypedElement)this.leftRevision;
            }
            return super.getLocalElement();
        }

        protected FileRevisionTypedElement getRightRevision() {
            if (this.rightRevision instanceof FileRevisionTypedElement) {
                return (FileRevisionTypedElement)this.rightRevision;
            }
            return null;
        }

        protected FileRevisionTypedElement getLeftRevision() {
            if (this.leftRevision instanceof FileRevisionTypedElement) {
                return (FileRevisionTypedElement)this.leftRevision;
            }
            return null;
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return null;
            }
            return super.getAdapter(adapter);
        }

        protected void handleDispose() {
            if (this.leftIsLocal && this.structureCreator != null) {
                EditionHistoryPage.internalDestroy(this.structureCreator, this.getLeft());
            }
            this.structureCreator = null;
            super.handleDispose();
        }
    }
}

